/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateIPSecConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateIPSecConnectionRequest
extends BmcRequest {
    private String ipscId;
    private UpdateIPSecConnectionDetails updateIPSecConnectionDetails;
    private String ifMatch;

    @ConstructorProperties(value={"ipscId", "updateIPSecConnectionDetails", "ifMatch"})
    UpdateIPSecConnectionRequest(String ipscId, UpdateIPSecConnectionDetails updateIPSecConnectionDetails, String ifMatch) {
        this.ipscId = ipscId;
        this.updateIPSecConnectionDetails = updateIPSecConnectionDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIpscId() {
        return this.ipscId;
    }

    public UpdateIPSecConnectionDetails getUpdateIPSecConnectionDetails() {
        return this.updateIPSecConnectionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String ipscId;
        private UpdateIPSecConnectionDetails updateIPSecConnectionDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateIPSecConnectionRequest o) {
            this.ipscId(o.getIpscId());
            this.updateIPSecConnectionDetails(o.getUpdateIPSecConnectionDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateIPSecConnectionRequest build() {
            UpdateIPSecConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder updateIPSecConnectionDetails(UpdateIPSecConnectionDetails updateIPSecConnectionDetails) {
            this.updateIPSecConnectionDetails = updateIPSecConnectionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateIPSecConnectionRequest buildWithoutInvocationCallback() {
            return new UpdateIPSecConnectionRequest(this.ipscId, this.updateIPSecConnectionDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateIPSecConnectionRequest.Builder(ipscId=" + this.ipscId + ", updateIPSecConnectionDetails=" + this.updateIPSecConnectionDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

