/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateImageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateImageRequest
extends BmcRequest {
    private String imageId;
    private UpdateImageDetails updateImageDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"imageId", "updateImageDetails", "opcRetryToken", "ifMatch"})
    UpdateImageRequest(String imageId, UpdateImageDetails updateImageDetails, String opcRetryToken, String ifMatch) {
        this.imageId = imageId;
        this.updateImageDetails = updateImageDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getImageId() {
        return this.imageId;
    }

    public UpdateImageDetails getUpdateImageDetails() {
        return this.updateImageDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String imageId;
        private UpdateImageDetails updateImageDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateImageRequest o) {
            this.imageId(o.getImageId());
            this.updateImageDetails(o.getUpdateImageDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateImageRequest build() {
            UpdateImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder updateImageDetails(UpdateImageDetails updateImageDetails) {
            this.updateImageDetails = updateImageDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateImageRequest buildWithoutInvocationCallback() {
            return new UpdateImageRequest(this.imageId, this.updateImageDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "UpdateImageRequest.Builder(imageId=" + this.imageId + ", updateImageDetails=" + this.updateImageDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

