/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateInstanceConfigurationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateInstanceConfigurationRequest
extends BmcRequest {
    private String instanceConfigurationId;
    private UpdateInstanceConfigurationDetails updateInstanceConfigurationDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"instanceConfigurationId", "updateInstanceConfigurationDetails", "opcRetryToken", "ifMatch"})
    UpdateInstanceConfigurationRequest(String instanceConfigurationId, UpdateInstanceConfigurationDetails updateInstanceConfigurationDetails, String opcRetryToken, String ifMatch) {
        this.instanceConfigurationId = instanceConfigurationId;
        this.updateInstanceConfigurationDetails = updateInstanceConfigurationDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public UpdateInstanceConfigurationDetails getUpdateInstanceConfigurationDetails() {
        return this.updateInstanceConfigurationDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instanceConfigurationId;
        private UpdateInstanceConfigurationDetails updateInstanceConfigurationDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateInstanceConfigurationRequest o) {
            this.instanceConfigurationId(o.getInstanceConfigurationId());
            this.updateInstanceConfigurationDetails(o.getUpdateInstanceConfigurationDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateInstanceConfigurationRequest build() {
            UpdateInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            return this;
        }

        public Builder updateInstanceConfigurationDetails(UpdateInstanceConfigurationDetails updateInstanceConfigurationDetails) {
            this.updateInstanceConfigurationDetails = updateInstanceConfigurationDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateInstanceConfigurationRequest buildWithoutInvocationCallback() {
            return new UpdateInstanceConfigurationRequest(this.instanceConfigurationId, this.updateInstanceConfigurationDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "UpdateInstanceConfigurationRequest.Builder(instanceConfigurationId=" + this.instanceConfigurationId + ", updateInstanceConfigurationDetails=" + this.updateInstanceConfigurationDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

