/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateInstancePoolDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateInstancePoolRequest
extends BmcRequest {
    private String instancePoolId;
    private UpdateInstancePoolDetails updateInstancePoolDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"instancePoolId", "updateInstancePoolDetails", "opcRetryToken", "ifMatch"})
    UpdateInstancePoolRequest(String instancePoolId, UpdateInstancePoolDetails updateInstancePoolDetails, String opcRetryToken, String ifMatch) {
        this.instancePoolId = instancePoolId;
        this.updateInstancePoolDetails = updateInstancePoolDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public UpdateInstancePoolDetails getUpdateInstancePoolDetails() {
        return this.updateInstancePoolDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instancePoolId;
        private UpdateInstancePoolDetails updateInstancePoolDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateInstancePoolRequest o) {
            this.instancePoolId(o.getInstancePoolId());
            this.updateInstancePoolDetails(o.getUpdateInstancePoolDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateInstancePoolRequest build() {
            UpdateInstancePoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder updateInstancePoolDetails(UpdateInstancePoolDetails updateInstancePoolDetails) {
            this.updateInstancePoolDetails = updateInstancePoolDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateInstancePoolRequest buildWithoutInvocationCallback() {
            return new UpdateInstancePoolRequest(this.instancePoolId, this.updateInstancePoolDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "UpdateInstancePoolRequest.Builder(instancePoolId=" + this.instancePoolId + ", updateInstancePoolDetails=" + this.updateInstancePoolDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

