/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateInstanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateInstanceRequest
extends BmcRequest {
    private String instanceId;
    private UpdateInstanceDetails updateInstanceDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"instanceId", "updateInstanceDetails", "opcRetryToken", "ifMatch"})
    UpdateInstanceRequest(String instanceId, UpdateInstanceDetails updateInstanceDetails, String opcRetryToken, String ifMatch) {
        this.instanceId = instanceId;
        this.updateInstanceDetails = updateInstanceDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public UpdateInstanceDetails getUpdateInstanceDetails() {
        return this.updateInstanceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instanceId;
        private UpdateInstanceDetails updateInstanceDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateInstanceRequest o) {
            this.instanceId(o.getInstanceId());
            this.updateInstanceDetails(o.getUpdateInstanceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateInstanceRequest build() {
            UpdateInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder updateInstanceDetails(UpdateInstanceDetails updateInstanceDetails) {
            this.updateInstanceDetails = updateInstanceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateInstanceRequest buildWithoutInvocationCallback() {
            return new UpdateInstanceRequest(this.instanceId, this.updateInstanceDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "UpdateInstanceRequest.Builder(instanceId=" + this.instanceId + ", updateInstanceDetails=" + this.updateInstanceDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

