/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateIpv6Details;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateIpv6Request
extends BmcRequest {
    private String ipv6Id;
    private UpdateIpv6Details updateIpv6Details;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"ipv6Id", "updateIpv6Details", "ifMatch", "opcRequestId"})
    UpdateIpv6Request(String ipv6Id, UpdateIpv6Details updateIpv6Details, String ifMatch, String opcRequestId) {
        this.ipv6Id = ipv6Id;
        this.updateIpv6Details = updateIpv6Details;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIpv6Id() {
        return this.ipv6Id;
    }

    public UpdateIpv6Details getUpdateIpv6Details() {
        return this.updateIpv6Details;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String ipv6Id;
        private UpdateIpv6Details updateIpv6Details;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateIpv6Request o) {
            this.ipv6Id(o.getIpv6Id());
            this.updateIpv6Details(o.getUpdateIpv6Details());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateIpv6Request build() {
            UpdateIpv6Request request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder ipv6Id(String ipv6Id) {
            this.ipv6Id = ipv6Id;
            return this;
        }

        public Builder updateIpv6Details(UpdateIpv6Details updateIpv6Details) {
            this.updateIpv6Details = updateIpv6Details;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateIpv6Request buildWithoutInvocationCallback() {
            return new UpdateIpv6Request(this.ipv6Id, this.updateIpv6Details, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateIpv6Request.Builder(ipv6Id=" + this.ipv6Id + ", updateIpv6Details=" + this.updateIpv6Details + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

