/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateNatGatewayDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateNatGatewayRequest
extends BmcRequest {
    private String natGatewayId;
    private UpdateNatGatewayDetails updateNatGatewayDetails;
    private String ifMatch;

    @ConstructorProperties(value={"natGatewayId", "updateNatGatewayDetails", "ifMatch"})
    UpdateNatGatewayRequest(String natGatewayId, UpdateNatGatewayDetails updateNatGatewayDetails, String ifMatch) {
        this.natGatewayId = natGatewayId;
        this.updateNatGatewayDetails = updateNatGatewayDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNatGatewayId() {
        return this.natGatewayId;
    }

    public UpdateNatGatewayDetails getUpdateNatGatewayDetails() {
        return this.updateNatGatewayDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String natGatewayId;
        private UpdateNatGatewayDetails updateNatGatewayDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateNatGatewayRequest o) {
            this.natGatewayId(o.getNatGatewayId());
            this.updateNatGatewayDetails(o.getUpdateNatGatewayDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateNatGatewayRequest build() {
            UpdateNatGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public Builder updateNatGatewayDetails(UpdateNatGatewayDetails updateNatGatewayDetails) {
            this.updateNatGatewayDetails = updateNatGatewayDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateNatGatewayRequest buildWithoutInvocationCallback() {
            return new UpdateNatGatewayRequest(this.natGatewayId, this.updateNatGatewayDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateNatGatewayRequest.Builder(natGatewayId=" + this.natGatewayId + ", updateNatGatewayDetails=" + this.updateNatGatewayDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

