/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdatePrivateIpDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdatePrivateIpRequest
extends BmcRequest {
    private String privateIpId;
    private UpdatePrivateIpDetails updatePrivateIpDetails;
    private String ifMatch;

    @ConstructorProperties(value={"privateIpId", "updatePrivateIpDetails", "ifMatch"})
    UpdatePrivateIpRequest(String privateIpId, UpdatePrivateIpDetails updatePrivateIpDetails, String ifMatch) {
        this.privateIpId = privateIpId;
        this.updatePrivateIpDetails = updatePrivateIpDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrivateIpId() {
        return this.privateIpId;
    }

    public UpdatePrivateIpDetails getUpdatePrivateIpDetails() {
        return this.updatePrivateIpDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String privateIpId;
        private UpdatePrivateIpDetails updatePrivateIpDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePrivateIpRequest o) {
            this.privateIpId(o.getPrivateIpId());
            this.updatePrivateIpDetails(o.getUpdatePrivateIpDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePrivateIpRequest build() {
            UpdatePrivateIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder privateIpId(String privateIpId) {
            this.privateIpId = privateIpId;
            return this;
        }

        public Builder updatePrivateIpDetails(UpdatePrivateIpDetails updatePrivateIpDetails) {
            this.updatePrivateIpDetails = updatePrivateIpDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdatePrivateIpRequest buildWithoutInvocationCallback() {
            return new UpdatePrivateIpRequest(this.privateIpId, this.updatePrivateIpDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdatePrivateIpRequest.Builder(privateIpId=" + this.privateIpId + ", updatePrivateIpDetails=" + this.updatePrivateIpDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

