/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdatePublicIpDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdatePublicIpRequest
extends BmcRequest {
    private String publicIpId;
    private UpdatePublicIpDetails updatePublicIpDetails;
    private String ifMatch;

    @ConstructorProperties(value={"publicIpId", "updatePublicIpDetails", "ifMatch"})
    UpdatePublicIpRequest(String publicIpId, UpdatePublicIpDetails updatePublicIpDetails, String ifMatch) {
        this.publicIpId = publicIpId;
        this.updatePublicIpDetails = updatePublicIpDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPublicIpId() {
        return this.publicIpId;
    }

    public UpdatePublicIpDetails getUpdatePublicIpDetails() {
        return this.updatePublicIpDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String publicIpId;
        private UpdatePublicIpDetails updatePublicIpDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePublicIpRequest o) {
            this.publicIpId(o.getPublicIpId());
            this.updatePublicIpDetails(o.getUpdatePublicIpDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePublicIpRequest build() {
            UpdatePublicIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder publicIpId(String publicIpId) {
            this.publicIpId = publicIpId;
            return this;
        }

        public Builder updatePublicIpDetails(UpdatePublicIpDetails updatePublicIpDetails) {
            this.updatePublicIpDetails = updatePublicIpDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdatePublicIpRequest buildWithoutInvocationCallback() {
            return new UpdatePublicIpRequest(this.publicIpId, this.updatePublicIpDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdatePublicIpRequest.Builder(publicIpId=" + this.publicIpId + ", updatePublicIpDetails=" + this.updatePublicIpDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

