/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateRouteTableDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateRouteTableRequest
extends BmcRequest {
    private String rtId;
    private UpdateRouteTableDetails updateRouteTableDetails;
    private String ifMatch;

    @ConstructorProperties(value={"rtId", "updateRouteTableDetails", "ifMatch"})
    UpdateRouteTableRequest(String rtId, UpdateRouteTableDetails updateRouteTableDetails, String ifMatch) {
        this.rtId = rtId;
        this.updateRouteTableDetails = updateRouteTableDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRtId() {
        return this.rtId;
    }

    public UpdateRouteTableDetails getUpdateRouteTableDetails() {
        return this.updateRouteTableDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String rtId;
        private UpdateRouteTableDetails updateRouteTableDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRouteTableRequest o) {
            this.rtId(o.getRtId());
            this.updateRouteTableDetails(o.getUpdateRouteTableDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRouteTableRequest build() {
            UpdateRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder rtId(String rtId) {
            this.rtId = rtId;
            return this;
        }

        public Builder updateRouteTableDetails(UpdateRouteTableDetails updateRouteTableDetails) {
            this.updateRouteTableDetails = updateRouteTableDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateRouteTableRequest buildWithoutInvocationCallback() {
            return new UpdateRouteTableRequest(this.rtId, this.updateRouteTableDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateRouteTableRequest.Builder(rtId=" + this.rtId + ", updateRouteTableDetails=" + this.updateRouteTableDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

