/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateSecurityListDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateSecurityListRequest
extends BmcRequest {
    private String securityListId;
    private UpdateSecurityListDetails updateSecurityListDetails;
    private String ifMatch;

    @ConstructorProperties(value={"securityListId", "updateSecurityListDetails", "ifMatch"})
    UpdateSecurityListRequest(String securityListId, UpdateSecurityListDetails updateSecurityListDetails, String ifMatch) {
        this.securityListId = securityListId;
        this.updateSecurityListDetails = updateSecurityListDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSecurityListId() {
        return this.securityListId;
    }

    public UpdateSecurityListDetails getUpdateSecurityListDetails() {
        return this.updateSecurityListDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String securityListId;
        private UpdateSecurityListDetails updateSecurityListDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSecurityListRequest o) {
            this.securityListId(o.getSecurityListId());
            this.updateSecurityListDetails(o.getUpdateSecurityListDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSecurityListRequest build() {
            UpdateSecurityListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder securityListId(String securityListId) {
            this.securityListId = securityListId;
            return this;
        }

        public Builder updateSecurityListDetails(UpdateSecurityListDetails updateSecurityListDetails) {
            this.updateSecurityListDetails = updateSecurityListDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateSecurityListRequest buildWithoutInvocationCallback() {
            return new UpdateSecurityListRequest(this.securityListId, this.updateSecurityListDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateSecurityListRequest.Builder(securityListId=" + this.securityListId + ", updateSecurityListDetails=" + this.updateSecurityListDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

