/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateServiceGatewayDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateServiceGatewayRequest
extends BmcRequest {
    private String serviceGatewayId;
    private UpdateServiceGatewayDetails updateServiceGatewayDetails;
    private String ifMatch;

    @ConstructorProperties(value={"serviceGatewayId", "updateServiceGatewayDetails", "ifMatch"})
    UpdateServiceGatewayRequest(String serviceGatewayId, UpdateServiceGatewayDetails updateServiceGatewayDetails, String ifMatch) {
        this.serviceGatewayId = serviceGatewayId;
        this.updateServiceGatewayDetails = updateServiceGatewayDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceGatewayId() {
        return this.serviceGatewayId;
    }

    public UpdateServiceGatewayDetails getUpdateServiceGatewayDetails() {
        return this.updateServiceGatewayDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String serviceGatewayId;
        private UpdateServiceGatewayDetails updateServiceGatewayDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateServiceGatewayRequest o) {
            this.serviceGatewayId(o.getServiceGatewayId());
            this.updateServiceGatewayDetails(o.getUpdateServiceGatewayDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateServiceGatewayRequest build() {
            UpdateServiceGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceGatewayId(String serviceGatewayId) {
            this.serviceGatewayId = serviceGatewayId;
            return this;
        }

        public Builder updateServiceGatewayDetails(UpdateServiceGatewayDetails updateServiceGatewayDetails) {
            this.updateServiceGatewayDetails = updateServiceGatewayDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateServiceGatewayRequest buildWithoutInvocationCallback() {
            return new UpdateServiceGatewayRequest(this.serviceGatewayId, this.updateServiceGatewayDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateServiceGatewayRequest.Builder(serviceGatewayId=" + this.serviceGatewayId + ", updateServiceGatewayDetails=" + this.updateServiceGatewayDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

