/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateSubnetDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateSubnetRequest
extends BmcRequest {
    private String subnetId;
    private UpdateSubnetDetails updateSubnetDetails;
    private String ifMatch;

    @ConstructorProperties(value={"subnetId", "updateSubnetDetails", "ifMatch"})
    UpdateSubnetRequest(String subnetId, UpdateSubnetDetails updateSubnetDetails, String ifMatch) {
        this.subnetId = subnetId;
        this.updateSubnetDetails = updateSubnetDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public UpdateSubnetDetails getUpdateSubnetDetails() {
        return this.updateSubnetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String subnetId;
        private UpdateSubnetDetails updateSubnetDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSubnetRequest o) {
            this.subnetId(o.getSubnetId());
            this.updateSubnetDetails(o.getUpdateSubnetDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSubnetRequest build() {
            UpdateSubnetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder updateSubnetDetails(UpdateSubnetDetails updateSubnetDetails) {
            this.updateSubnetDetails = updateSubnetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateSubnetRequest buildWithoutInvocationCallback() {
            return new UpdateSubnetRequest(this.subnetId, this.updateSubnetDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateSubnetRequest.Builder(subnetId=" + this.subnetId + ", updateSubnetDetails=" + this.updateSubnetDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

