/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateVcnDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateVcnRequest
extends BmcRequest {
    private String vcnId;
    private UpdateVcnDetails updateVcnDetails;
    private String ifMatch;

    @ConstructorProperties(value={"vcnId", "updateVcnDetails", "ifMatch"})
    UpdateVcnRequest(String vcnId, UpdateVcnDetails updateVcnDetails, String ifMatch) {
        this.vcnId = vcnId;
        this.updateVcnDetails = updateVcnDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public UpdateVcnDetails getUpdateVcnDetails() {
        return this.updateVcnDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String vcnId;
        private UpdateVcnDetails updateVcnDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVcnRequest o) {
            this.vcnId(o.getVcnId());
            this.updateVcnDetails(o.getUpdateVcnDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVcnRequest build() {
            UpdateVcnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            return this;
        }

        public Builder updateVcnDetails(UpdateVcnDetails updateVcnDetails) {
            this.updateVcnDetails = updateVcnDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateVcnRequest buildWithoutInvocationCallback() {
            return new UpdateVcnRequest(this.vcnId, this.updateVcnDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateVcnRequest.Builder(vcnId=" + this.vcnId + ", updateVcnDetails=" + this.updateVcnDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

