/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateVirtualCircuitDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateVirtualCircuitRequest
extends BmcRequest {
    private String virtualCircuitId;
    private UpdateVirtualCircuitDetails updateVirtualCircuitDetails;
    private String ifMatch;

    @ConstructorProperties(value={"virtualCircuitId", "updateVirtualCircuitDetails", "ifMatch"})
    UpdateVirtualCircuitRequest(String virtualCircuitId, UpdateVirtualCircuitDetails updateVirtualCircuitDetails, String ifMatch) {
        this.virtualCircuitId = virtualCircuitId;
        this.updateVirtualCircuitDetails = updateVirtualCircuitDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVirtualCircuitId() {
        return this.virtualCircuitId;
    }

    public UpdateVirtualCircuitDetails getUpdateVirtualCircuitDetails() {
        return this.updateVirtualCircuitDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String virtualCircuitId;
        private UpdateVirtualCircuitDetails updateVirtualCircuitDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVirtualCircuitRequest o) {
            this.virtualCircuitId(o.getVirtualCircuitId());
            this.updateVirtualCircuitDetails(o.getUpdateVirtualCircuitDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVirtualCircuitRequest build() {
            UpdateVirtualCircuitRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder virtualCircuitId(String virtualCircuitId) {
            this.virtualCircuitId = virtualCircuitId;
            return this;
        }

        public Builder updateVirtualCircuitDetails(UpdateVirtualCircuitDetails updateVirtualCircuitDetails) {
            this.updateVirtualCircuitDetails = updateVirtualCircuitDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateVirtualCircuitRequest buildWithoutInvocationCallback() {
            return new UpdateVirtualCircuitRequest(this.virtualCircuitId, this.updateVirtualCircuitDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateVirtualCircuitRequest.Builder(virtualCircuitId=" + this.virtualCircuitId + ", updateVirtualCircuitDetails=" + this.updateVirtualCircuitDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

