/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateVnicDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateVnicRequest
extends BmcRequest {
    private String vnicId;
    private UpdateVnicDetails updateVnicDetails;
    private String ifMatch;

    @ConstructorProperties(value={"vnicId", "updateVnicDetails", "ifMatch"})
    UpdateVnicRequest(String vnicId, UpdateVnicDetails updateVnicDetails, String ifMatch) {
        this.vnicId = vnicId;
        this.updateVnicDetails = updateVnicDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public UpdateVnicDetails getUpdateVnicDetails() {
        return this.updateVnicDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String vnicId;
        private UpdateVnicDetails updateVnicDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVnicRequest o) {
            this.vnicId(o.getVnicId());
            this.updateVnicDetails(o.getUpdateVnicDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVnicRequest build() {
            UpdateVnicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public Builder updateVnicDetails(UpdateVnicDetails updateVnicDetails) {
            this.updateVnicDetails = updateVnicDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateVnicRequest buildWithoutInvocationCallback() {
            return new UpdateVnicRequest(this.vnicId, this.updateVnicDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateVnicRequest.Builder(vnicId=" + this.vnicId + ", updateVnicDetails=" + this.updateVnicDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

