/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateVolumeBackupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateVolumeBackupRequest
extends BmcRequest {
    private String volumeBackupId;
    private UpdateVolumeBackupDetails updateVolumeBackupDetails;
    private String ifMatch;

    @ConstructorProperties(value={"volumeBackupId", "updateVolumeBackupDetails", "ifMatch"})
    UpdateVolumeBackupRequest(String volumeBackupId, UpdateVolumeBackupDetails updateVolumeBackupDetails, String ifMatch) {
        this.volumeBackupId = volumeBackupId;
        this.updateVolumeBackupDetails = updateVolumeBackupDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeBackupId() {
        return this.volumeBackupId;
    }

    public UpdateVolumeBackupDetails getUpdateVolumeBackupDetails() {
        return this.updateVolumeBackupDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String volumeBackupId;
        private UpdateVolumeBackupDetails updateVolumeBackupDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVolumeBackupRequest o) {
            this.volumeBackupId(o.getVolumeBackupId());
            this.updateVolumeBackupDetails(o.getUpdateVolumeBackupDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVolumeBackupRequest build() {
            UpdateVolumeBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeBackupId(String volumeBackupId) {
            this.volumeBackupId = volumeBackupId;
            return this;
        }

        public Builder updateVolumeBackupDetails(UpdateVolumeBackupDetails updateVolumeBackupDetails) {
            this.updateVolumeBackupDetails = updateVolumeBackupDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateVolumeBackupRequest buildWithoutInvocationCallback() {
            return new UpdateVolumeBackupRequest(this.volumeBackupId, this.updateVolumeBackupDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateVolumeBackupRequest.Builder(volumeBackupId=" + this.volumeBackupId + ", updateVolumeBackupDetails=" + this.updateVolumeBackupDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

