/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateVolumeGroupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateVolumeGroupRequest
extends BmcRequest {
    private String volumeGroupId;
    private UpdateVolumeGroupDetails updateVolumeGroupDetails;
    private String ifMatch;

    @ConstructorProperties(value={"volumeGroupId", "updateVolumeGroupDetails", "ifMatch"})
    UpdateVolumeGroupRequest(String volumeGroupId, UpdateVolumeGroupDetails updateVolumeGroupDetails, String ifMatch) {
        this.volumeGroupId = volumeGroupId;
        this.updateVolumeGroupDetails = updateVolumeGroupDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public UpdateVolumeGroupDetails getUpdateVolumeGroupDetails() {
        return this.updateVolumeGroupDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String volumeGroupId;
        private UpdateVolumeGroupDetails updateVolumeGroupDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVolumeGroupRequest o) {
            this.volumeGroupId(o.getVolumeGroupId());
            this.updateVolumeGroupDetails(o.getUpdateVolumeGroupDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVolumeGroupRequest build() {
            UpdateVolumeGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            return this;
        }

        public Builder updateVolumeGroupDetails(UpdateVolumeGroupDetails updateVolumeGroupDetails) {
            this.updateVolumeGroupDetails = updateVolumeGroupDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateVolumeGroupRequest buildWithoutInvocationCallback() {
            return new UpdateVolumeGroupRequest(this.volumeGroupId, this.updateVolumeGroupDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateVolumeGroupRequest.Builder(volumeGroupId=" + this.volumeGroupId + ", updateVolumeGroupDetails=" + this.updateVolumeGroupDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

