/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateVolumeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateVolumeRequest
extends BmcRequest {
    private String volumeId;
    private UpdateVolumeDetails updateVolumeDetails;
    private String ifMatch;

    @ConstructorProperties(value={"volumeId", "updateVolumeDetails", "ifMatch"})
    UpdateVolumeRequest(String volumeId, UpdateVolumeDetails updateVolumeDetails, String ifMatch) {
        this.volumeId = volumeId;
        this.updateVolumeDetails = updateVolumeDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public UpdateVolumeDetails getUpdateVolumeDetails() {
        return this.updateVolumeDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String volumeId;
        private UpdateVolumeDetails updateVolumeDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVolumeRequest o) {
            this.volumeId(o.getVolumeId());
            this.updateVolumeDetails(o.getUpdateVolumeDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVolumeRequest build() {
            UpdateVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder updateVolumeDetails(UpdateVolumeDetails updateVolumeDetails) {
            this.updateVolumeDetails = updateVolumeDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateVolumeRequest buildWithoutInvocationCallback() {
            return new UpdateVolumeRequest(this.volumeId, this.updateVolumeDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateVolumeRequest.Builder(volumeId=" + this.volumeId + ", updateVolumeDetails=" + this.updateVolumeDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

