/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.ServiceGateway;
import java.beans.ConstructorProperties;

public class AttachServiceIdResponse {
    private String opcRequestId;
    private ServiceGateway serviceGateway;

    @ConstructorProperties(value={"opcRequestId", "serviceGateway"})
    AttachServiceIdResponse(String opcRequestId, ServiceGateway serviceGateway) {
        this.opcRequestId = opcRequestId;
        this.serviceGateway = serviceGateway;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ServiceGateway getServiceGateway() {
        return this.serviceGateway;
    }

    public static class Builder {
        private String opcRequestId;
        private ServiceGateway serviceGateway;

        public Builder copy(AttachServiceIdResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.serviceGateway(o.getServiceGateway());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder serviceGateway(ServiceGateway serviceGateway) {
            this.serviceGateway = serviceGateway;
            return this;
        }

        public AttachServiceIdResponse build() {
            return new AttachServiceIdResponse(this.opcRequestId, this.serviceGateway);
        }

        public String toString() {
            return "AttachServiceIdResponse.Builder(opcRequestId=" + this.opcRequestId + ", serviceGateway=" + this.serviceGateway + ")";
        }
    }
}

