/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import java.beans.ConstructorProperties;

public class ChangeDrgCompartmentResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcWorkRequestId"})
    ChangeDrgCompartmentResponse(String etag, String opcRequestId, String opcWorkRequestId) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;

        public Builder copy(ChangeDrgCompartmentResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public ChangeDrgCompartmentResponse build() {
            return new ChangeDrgCompartmentResponse(this.etag, this.opcRequestId, this.opcWorkRequestId);
        }

        public String toString() {
            return "ChangeDrgCompartmentResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcWorkRequestId=" + this.opcWorkRequestId + ")";
        }
    }
}

