/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.AppCatalogSubscription;
import java.beans.ConstructorProperties;

public class CreateAppCatalogSubscriptionResponse {
    private String etag;
    private String opcRequestId;
    private AppCatalogSubscription appCatalogSubscription;

    @ConstructorProperties(value={"etag", "opcRequestId", "appCatalogSubscription"})
    CreateAppCatalogSubscriptionResponse(String etag, String opcRequestId, AppCatalogSubscription appCatalogSubscription) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.appCatalogSubscription = appCatalogSubscription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AppCatalogSubscription getAppCatalogSubscription() {
        return this.appCatalogSubscription;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private AppCatalogSubscription appCatalogSubscription;

        public Builder copy(CreateAppCatalogSubscriptionResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.appCatalogSubscription(o.getAppCatalogSubscription());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder appCatalogSubscription(AppCatalogSubscription appCatalogSubscription) {
            this.appCatalogSubscription = appCatalogSubscription;
            return this;
        }

        public CreateAppCatalogSubscriptionResponse build() {
            return new CreateAppCatalogSubscriptionResponse(this.etag, this.opcRequestId, this.appCatalogSubscription);
        }

        public String toString() {
            return "CreateAppCatalogSubscriptionResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", appCatalogSubscription=" + this.appCatalogSubscription + ")";
        }
    }
}

