/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.BootVolumeBackup;
import java.beans.ConstructorProperties;

public class CreateBootVolumeBackupResponse {
    private String etag;
    private String opcRequestId;
    private BootVolumeBackup bootVolumeBackup;

    @ConstructorProperties(value={"etag", "opcRequestId", "bootVolumeBackup"})
    CreateBootVolumeBackupResponse(String etag, String opcRequestId, BootVolumeBackup bootVolumeBackup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.bootVolumeBackup = bootVolumeBackup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BootVolumeBackup getBootVolumeBackup() {
        return this.bootVolumeBackup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private BootVolumeBackup bootVolumeBackup;

        public Builder copy(CreateBootVolumeBackupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.bootVolumeBackup(o.getBootVolumeBackup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder bootVolumeBackup(BootVolumeBackup bootVolumeBackup) {
            this.bootVolumeBackup = bootVolumeBackup;
            return this;
        }

        public CreateBootVolumeBackupResponse build() {
            return new CreateBootVolumeBackupResponse(this.etag, this.opcRequestId, this.bootVolumeBackup);
        }

        public String toString() {
            return "CreateBootVolumeBackupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", bootVolumeBackup=" + this.bootVolumeBackup + ")";
        }
    }
}

