/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.ClusterNetwork;
import java.beans.ConstructorProperties;

public class CreateClusterNetworkResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private ClusterNetwork clusterNetwork;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcWorkRequestId", "clusterNetwork"})
    CreateClusterNetworkResponse(String etag, String opcRequestId, String opcWorkRequestId, ClusterNetwork clusterNetwork) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.clusterNetwork = clusterNetwork;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public ClusterNetwork getClusterNetwork() {
        return this.clusterNetwork;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private ClusterNetwork clusterNetwork;

        public Builder copy(CreateClusterNetworkResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.clusterNetwork(o.getClusterNetwork());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder clusterNetwork(ClusterNetwork clusterNetwork) {
            this.clusterNetwork = clusterNetwork;
            return this;
        }

        public CreateClusterNetworkResponse build() {
            return new CreateClusterNetworkResponse(this.etag, this.opcRequestId, this.opcWorkRequestId, this.clusterNetwork);
        }

        public String toString() {
            return "CreateClusterNetworkResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcWorkRequestId=" + this.opcWorkRequestId + ", clusterNetwork=" + this.clusterNetwork + ")";
        }
    }
}

