/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.DedicatedVmHost;
import java.beans.ConstructorProperties;

public class CreateDedicatedVmHostResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private DedicatedVmHost dedicatedVmHost;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcWorkRequestId", "dedicatedVmHost"})
    CreateDedicatedVmHostResponse(String etag, String opcRequestId, String opcWorkRequestId, DedicatedVmHost dedicatedVmHost) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.dedicatedVmHost = dedicatedVmHost;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public DedicatedVmHost getDedicatedVmHost() {
        return this.dedicatedVmHost;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private DedicatedVmHost dedicatedVmHost;

        public Builder copy(CreateDedicatedVmHostResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.dedicatedVmHost(o.getDedicatedVmHost());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder dedicatedVmHost(DedicatedVmHost dedicatedVmHost) {
            this.dedicatedVmHost = dedicatedVmHost;
            return this;
        }

        public CreateDedicatedVmHostResponse build() {
            return new CreateDedicatedVmHostResponse(this.etag, this.opcRequestId, this.opcWorkRequestId, this.dedicatedVmHost);
        }

        public String toString() {
            return "CreateDedicatedVmHostResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcWorkRequestId=" + this.opcWorkRequestId + ", dedicatedVmHost=" + this.dedicatedVmHost + ")";
        }
    }
}

