/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Drg;
import java.beans.ConstructorProperties;

public class CreateDrgResponse {
    private String etag;
    private String opcRequestId;
    private Drg drg;

    @ConstructorProperties(value={"etag", "opcRequestId", "drg"})
    CreateDrgResponse(String etag, String opcRequestId, Drg drg) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.drg = drg;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Drg getDrg() {
        return this.drg;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Drg drg;

        public Builder copy(CreateDrgResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.drg(o.getDrg());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder drg(Drg drg) {
            this.drg = drg;
            return this;
        }

        public CreateDrgResponse build() {
            return new CreateDrgResponse(this.etag, this.opcRequestId, this.drg);
        }

        public String toString() {
            return "CreateDrgResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", drg=" + this.drg + ")";
        }
    }
}

