/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstanceConsoleConnection;
import java.beans.ConstructorProperties;

public class CreateInstanceConsoleConnectionResponse {
    private String etag;
    private String opcRequestId;
    private InstanceConsoleConnection instanceConsoleConnection;

    @ConstructorProperties(value={"etag", "opcRequestId", "instanceConsoleConnection"})
    CreateInstanceConsoleConnectionResponse(String etag, String opcRequestId, InstanceConsoleConnection instanceConsoleConnection) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.instanceConsoleConnection = instanceConsoleConnection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InstanceConsoleConnection getInstanceConsoleConnection() {
        return this.instanceConsoleConnection;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private InstanceConsoleConnection instanceConsoleConnection;

        public Builder copy(CreateInstanceConsoleConnectionResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.instanceConsoleConnection(o.getInstanceConsoleConnection());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder instanceConsoleConnection(InstanceConsoleConnection instanceConsoleConnection) {
            this.instanceConsoleConnection = instanceConsoleConnection;
            return this;
        }

        public CreateInstanceConsoleConnectionResponse build() {
            return new CreateInstanceConsoleConnectionResponse(this.etag, this.opcRequestId, this.instanceConsoleConnection);
        }

        public String toString() {
            return "CreateInstanceConsoleConnectionResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", instanceConsoleConnection=" + this.instanceConsoleConnection + ")";
        }
    }
}

