/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Ipv6;
import java.beans.ConstructorProperties;

public class CreateIpv6Response {
    private String etag;
    private String opcRequestId;
    private Ipv6 ipv6;

    @ConstructorProperties(value={"etag", "opcRequestId", "ipv6"})
    CreateIpv6Response(String etag, String opcRequestId, Ipv6 ipv6) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.ipv6 = ipv6;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Ipv6 getIpv6() {
        return this.ipv6;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Ipv6 ipv6;

        public Builder copy(CreateIpv6Response o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.ipv6(o.getIpv6());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ipv6(Ipv6 ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public CreateIpv6Response build() {
            return new CreateIpv6Response(this.etag, this.opcRequestId, this.ipv6);
        }

        public String toString() {
            return "CreateIpv6Response.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", ipv6=" + this.ipv6 + ")";
        }
    }
}

