/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.PrivateIp;
import java.beans.ConstructorProperties;

public class CreatePrivateIpResponse {
    private String etag;
    private String opcRequestId;
    private PrivateIp privateIp;

    @ConstructorProperties(value={"etag", "opcRequestId", "privateIp"})
    CreatePrivateIpResponse(String etag, String opcRequestId, PrivateIp privateIp) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.privateIp = privateIp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PrivateIp getPrivateIp() {
        return this.privateIp;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private PrivateIp privateIp;

        public Builder copy(CreatePrivateIpResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.privateIp(o.getPrivateIp());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder privateIp(PrivateIp privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public CreatePrivateIpResponse build() {
            return new CreatePrivateIpResponse(this.etag, this.opcRequestId, this.privateIp);
        }

        public String toString() {
            return "CreatePrivateIpResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", privateIp=" + this.privateIp + ")";
        }
    }
}

