/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.RemotePeeringConnection;
import java.beans.ConstructorProperties;

public class CreateRemotePeeringConnectionResponse {
    private String etag;
    private String opcRequestId;
    private RemotePeeringConnection remotePeeringConnection;

    @ConstructorProperties(value={"etag", "opcRequestId", "remotePeeringConnection"})
    CreateRemotePeeringConnectionResponse(String etag, String opcRequestId, RemotePeeringConnection remotePeeringConnection) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.remotePeeringConnection = remotePeeringConnection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RemotePeeringConnection getRemotePeeringConnection() {
        return this.remotePeeringConnection;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private RemotePeeringConnection remotePeeringConnection;

        public Builder copy(CreateRemotePeeringConnectionResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.remotePeeringConnection(o.getRemotePeeringConnection());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder remotePeeringConnection(RemotePeeringConnection remotePeeringConnection) {
            this.remotePeeringConnection = remotePeeringConnection;
            return this;
        }

        public CreateRemotePeeringConnectionResponse build() {
            return new CreateRemotePeeringConnectionResponse(this.etag, this.opcRequestId, this.remotePeeringConnection);
        }

        public String toString() {
            return "CreateRemotePeeringConnectionResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", remotePeeringConnection=" + this.remotePeeringConnection + ")";
        }
    }
}

