/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.RouteTable;
import java.beans.ConstructorProperties;

public class CreateRouteTableResponse {
    private String etag;
    private String opcRequestId;
    private RouteTable routeTable;

    @ConstructorProperties(value={"etag", "opcRequestId", "routeTable"})
    CreateRouteTableResponse(String etag, String opcRequestId, RouteTable routeTable) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.routeTable = routeTable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RouteTable getRouteTable() {
        return this.routeTable;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private RouteTable routeTable;

        public Builder copy(CreateRouteTableResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.routeTable(o.getRouteTable());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder routeTable(RouteTable routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public CreateRouteTableResponse build() {
            return new CreateRouteTableResponse(this.etag, this.opcRequestId, this.routeTable);
        }

        public String toString() {
            return "CreateRouteTableResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", routeTable=" + this.routeTable + ")";
        }
    }
}

