/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeBackupPolicy;
import java.beans.ConstructorProperties;

public class CreateVolumeBackupPolicyResponse {
    private String etag;
    private String opcRequestId;
    private VolumeBackupPolicy volumeBackupPolicy;

    @ConstructorProperties(value={"etag", "opcRequestId", "volumeBackupPolicy"})
    CreateVolumeBackupPolicyResponse(String etag, String opcRequestId, VolumeBackupPolicy volumeBackupPolicy) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.volumeBackupPolicy = volumeBackupPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VolumeBackupPolicy getVolumeBackupPolicy() {
        return this.volumeBackupPolicy;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VolumeBackupPolicy volumeBackupPolicy;

        public Builder copy(CreateVolumeBackupPolicyResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.volumeBackupPolicy(o.getVolumeBackupPolicy());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder volumeBackupPolicy(VolumeBackupPolicy volumeBackupPolicy) {
            this.volumeBackupPolicy = volumeBackupPolicy;
            return this;
        }

        public CreateVolumeBackupPolicyResponse build() {
            return new CreateVolumeBackupPolicyResponse(this.etag, this.opcRequestId, this.volumeBackupPolicy);
        }

        public String toString() {
            return "CreateVolumeBackupPolicyResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", volumeBackupPolicy=" + this.volumeBackupPolicy + ")";
        }
    }
}

