/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeBackup;
import java.beans.ConstructorProperties;

public class CreateVolumeBackupResponse {
    private String etag;
    private String opcRequestId;
    private VolumeBackup volumeBackup;

    @ConstructorProperties(value={"etag", "opcRequestId", "volumeBackup"})
    CreateVolumeBackupResponse(String etag, String opcRequestId, VolumeBackup volumeBackup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.volumeBackup = volumeBackup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VolumeBackup getVolumeBackup() {
        return this.volumeBackup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VolumeBackup volumeBackup;

        public Builder copy(CreateVolumeBackupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.volumeBackup(o.getVolumeBackup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder volumeBackup(VolumeBackup volumeBackup) {
            this.volumeBackup = volumeBackup;
            return this;
        }

        public CreateVolumeBackupResponse build() {
            return new CreateVolumeBackupResponse(this.etag, this.opcRequestId, this.volumeBackup);
        }

        public String toString() {
            return "CreateVolumeBackupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", volumeBackup=" + this.volumeBackup + ")";
        }
    }
}

