/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeGroupBackup;
import java.beans.ConstructorProperties;

public class CreateVolumeGroupBackupResponse {
    private String etag;
    private String opcRequestId;
    private VolumeGroupBackup volumeGroupBackup;

    @ConstructorProperties(value={"etag", "opcRequestId", "volumeGroupBackup"})
    CreateVolumeGroupBackupResponse(String etag, String opcRequestId, VolumeGroupBackup volumeGroupBackup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.volumeGroupBackup = volumeGroupBackup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VolumeGroupBackup getVolumeGroupBackup() {
        return this.volumeGroupBackup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VolumeGroupBackup volumeGroupBackup;

        public Builder copy(CreateVolumeGroupBackupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.volumeGroupBackup(o.getVolumeGroupBackup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder volumeGroupBackup(VolumeGroupBackup volumeGroupBackup) {
            this.volumeGroupBackup = volumeGroupBackup;
            return this;
        }

        public CreateVolumeGroupBackupResponse build() {
            return new CreateVolumeGroupBackupResponse(this.etag, this.opcRequestId, this.volumeGroupBackup);
        }

        public String toString() {
            return "CreateVolumeGroupBackupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", volumeGroupBackup=" + this.volumeGroupBackup + ")";
        }
    }
}

