/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Image;
import java.beans.ConstructorProperties;

public class ExportImageResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private Image image;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcWorkRequestId", "image"})
    ExportImageResponse(String etag, String opcRequestId, String opcWorkRequestId, Image image) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.image = image;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public Image getImage() {
        return this.image;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private Image image;

        public Builder copy(ExportImageResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.image(o.getImage());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public ExportImageResponse build() {
            return new ExportImageResponse(this.etag, this.opcRequestId, this.opcWorkRequestId, this.image);
        }

        public String toString() {
            return "ExportImageResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcWorkRequestId=" + this.opcWorkRequestId + ", image=" + this.image + ")";
        }
    }
}

