/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.AppCatalogListing;
import java.beans.ConstructorProperties;

public class GetAppCatalogListingResponse {
    private String etag;
    private String opcRequestId;
    private AppCatalogListing appCatalogListing;

    @ConstructorProperties(value={"etag", "opcRequestId", "appCatalogListing"})
    GetAppCatalogListingResponse(String etag, String opcRequestId, AppCatalogListing appCatalogListing) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.appCatalogListing = appCatalogListing;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AppCatalogListing getAppCatalogListing() {
        return this.appCatalogListing;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private AppCatalogListing appCatalogListing;

        public Builder copy(GetAppCatalogListingResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.appCatalogListing(o.getAppCatalogListing());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder appCatalogListing(AppCatalogListing appCatalogListing) {
            this.appCatalogListing = appCatalogListing;
            return this;
        }

        public GetAppCatalogListingResponse build() {
            return new GetAppCatalogListingResponse(this.etag, this.opcRequestId, this.appCatalogListing);
        }

        public String toString() {
            return "GetAppCatalogListingResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", appCatalogListing=" + this.appCatalogListing + ")";
        }
    }
}

