/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.BootVolumeAttachment;
import java.beans.ConstructorProperties;

public class GetBootVolumeAttachmentResponse {
    private String etag;
    private String opcRequestId;
    private BootVolumeAttachment bootVolumeAttachment;

    @ConstructorProperties(value={"etag", "opcRequestId", "bootVolumeAttachment"})
    GetBootVolumeAttachmentResponse(String etag, String opcRequestId, BootVolumeAttachment bootVolumeAttachment) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.bootVolumeAttachment = bootVolumeAttachment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BootVolumeAttachment getBootVolumeAttachment() {
        return this.bootVolumeAttachment;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private BootVolumeAttachment bootVolumeAttachment;

        public Builder copy(GetBootVolumeAttachmentResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.bootVolumeAttachment(o.getBootVolumeAttachment());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder bootVolumeAttachment(BootVolumeAttachment bootVolumeAttachment) {
            this.bootVolumeAttachment = bootVolumeAttachment;
            return this;
        }

        public GetBootVolumeAttachmentResponse build() {
            return new GetBootVolumeAttachmentResponse(this.etag, this.opcRequestId, this.bootVolumeAttachment);
        }

        public String toString() {
            return "GetBootVolumeAttachmentResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", bootVolumeAttachment=" + this.bootVolumeAttachment + ")";
        }
    }
}

