/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.BootVolumeKmsKey;
import java.beans.ConstructorProperties;

public class GetBootVolumeKmsKeyResponse {
    private String etag;
    private String opcRequestId;
    private BootVolumeKmsKey bootVolumeKmsKey;

    @ConstructorProperties(value={"etag", "opcRequestId", "bootVolumeKmsKey"})
    GetBootVolumeKmsKeyResponse(String etag, String opcRequestId, BootVolumeKmsKey bootVolumeKmsKey) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.bootVolumeKmsKey = bootVolumeKmsKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BootVolumeKmsKey getBootVolumeKmsKey() {
        return this.bootVolumeKmsKey;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private BootVolumeKmsKey bootVolumeKmsKey;

        public Builder copy(GetBootVolumeKmsKeyResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.bootVolumeKmsKey(o.getBootVolumeKmsKey());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder bootVolumeKmsKey(BootVolumeKmsKey bootVolumeKmsKey) {
            this.bootVolumeKmsKey = bootVolumeKmsKey;
            return this;
        }

        public GetBootVolumeKmsKeyResponse build() {
            return new GetBootVolumeKmsKeyResponse(this.etag, this.opcRequestId, this.bootVolumeKmsKey);
        }

        public String toString() {
            return "GetBootVolumeKmsKeyResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", bootVolumeKmsKey=" + this.bootVolumeKmsKey + ")";
        }
    }
}

