/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.ClusterNetwork;
import java.beans.ConstructorProperties;

public class GetClusterNetworkResponse {
    private String etag;
    private String opcRequestId;
    private ClusterNetwork clusterNetwork;

    @ConstructorProperties(value={"etag", "opcRequestId", "clusterNetwork"})
    GetClusterNetworkResponse(String etag, String opcRequestId, ClusterNetwork clusterNetwork) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.clusterNetwork = clusterNetwork;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ClusterNetwork getClusterNetwork() {
        return this.clusterNetwork;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private ClusterNetwork clusterNetwork;

        public Builder copy(GetClusterNetworkResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.clusterNetwork(o.getClusterNetwork());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder clusterNetwork(ClusterNetwork clusterNetwork) {
            this.clusterNetwork = clusterNetwork;
            return this;
        }

        public GetClusterNetworkResponse build() {
            return new GetClusterNetworkResponse(this.etag, this.opcRequestId, this.clusterNetwork);
        }

        public String toString() {
            return "GetClusterNetworkResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", clusterNetwork=" + this.clusterNetwork + ")";
        }
    }
}

