/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.CrossConnectGroup;
import java.beans.ConstructorProperties;

public class GetCrossConnectGroupResponse {
    private String etag;
    private String opcRequestId;
    private CrossConnectGroup crossConnectGroup;

    @ConstructorProperties(value={"etag", "opcRequestId", "crossConnectGroup"})
    GetCrossConnectGroupResponse(String etag, String opcRequestId, CrossConnectGroup crossConnectGroup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.crossConnectGroup = crossConnectGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public CrossConnectGroup getCrossConnectGroup() {
        return this.crossConnectGroup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private CrossConnectGroup crossConnectGroup;

        public Builder copy(GetCrossConnectGroupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.crossConnectGroup(o.getCrossConnectGroup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder crossConnectGroup(CrossConnectGroup crossConnectGroup) {
            this.crossConnectGroup = crossConnectGroup;
            return this;
        }

        public GetCrossConnectGroupResponse build() {
            return new GetCrossConnectGroupResponse(this.etag, this.opcRequestId, this.crossConnectGroup);
        }

        public String toString() {
            return "GetCrossConnectGroupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", crossConnectGroup=" + this.crossConnectGroup + ")";
        }
    }
}

