/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.LetterOfAuthority;
import java.beans.ConstructorProperties;

public class GetCrossConnectLetterOfAuthorityResponse {
    private String opcRequestId;
    private LetterOfAuthority letterOfAuthority;

    @ConstructorProperties(value={"opcRequestId", "letterOfAuthority"})
    GetCrossConnectLetterOfAuthorityResponse(String opcRequestId, LetterOfAuthority letterOfAuthority) {
        this.opcRequestId = opcRequestId;
        this.letterOfAuthority = letterOfAuthority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public LetterOfAuthority getLetterOfAuthority() {
        return this.letterOfAuthority;
    }

    public static class Builder {
        private String opcRequestId;
        private LetterOfAuthority letterOfAuthority;

        public Builder copy(GetCrossConnectLetterOfAuthorityResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.letterOfAuthority(o.getLetterOfAuthority());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder letterOfAuthority(LetterOfAuthority letterOfAuthority) {
            this.letterOfAuthority = letterOfAuthority;
            return this;
        }

        public GetCrossConnectLetterOfAuthorityResponse build() {
            return new GetCrossConnectLetterOfAuthorityResponse(this.opcRequestId, this.letterOfAuthority);
        }

        public String toString() {
            return "GetCrossConnectLetterOfAuthorityResponse.Builder(opcRequestId=" + this.opcRequestId + ", letterOfAuthority=" + this.letterOfAuthority + ")";
        }
    }
}

