/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.CrossConnectStatus;
import java.beans.ConstructorProperties;

public class GetCrossConnectStatusResponse {
    private String opcRequestId;
    private CrossConnectStatus crossConnectStatus;

    @ConstructorProperties(value={"opcRequestId", "crossConnectStatus"})
    GetCrossConnectStatusResponse(String opcRequestId, CrossConnectStatus crossConnectStatus) {
        this.opcRequestId = opcRequestId;
        this.crossConnectStatus = crossConnectStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public CrossConnectStatus getCrossConnectStatus() {
        return this.crossConnectStatus;
    }

    public static class Builder {
        private String opcRequestId;
        private CrossConnectStatus crossConnectStatus;

        public Builder copy(GetCrossConnectStatusResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.crossConnectStatus(o.getCrossConnectStatus());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder crossConnectStatus(CrossConnectStatus crossConnectStatus) {
            this.crossConnectStatus = crossConnectStatus;
            return this;
        }

        public GetCrossConnectStatusResponse build() {
            return new GetCrossConnectStatusResponse(this.opcRequestId, this.crossConnectStatus);
        }

        public String toString() {
            return "GetCrossConnectStatusResponse.Builder(opcRequestId=" + this.opcRequestId + ", crossConnectStatus=" + this.crossConnectStatus + ")";
        }
    }
}

