/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.DedicatedVmHost;
import java.beans.ConstructorProperties;

public class GetDedicatedVmHostResponse {
    private String etag;
    private String opcRequestId;
    private DedicatedVmHost dedicatedVmHost;

    @ConstructorProperties(value={"etag", "opcRequestId", "dedicatedVmHost"})
    GetDedicatedVmHostResponse(String etag, String opcRequestId, DedicatedVmHost dedicatedVmHost) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.dedicatedVmHost = dedicatedVmHost;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DedicatedVmHost getDedicatedVmHost() {
        return this.dedicatedVmHost;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private DedicatedVmHost dedicatedVmHost;

        public Builder copy(GetDedicatedVmHostResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.dedicatedVmHost(o.getDedicatedVmHost());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dedicatedVmHost(DedicatedVmHost dedicatedVmHost) {
            this.dedicatedVmHost = dedicatedVmHost;
            return this;
        }

        public GetDedicatedVmHostResponse build() {
            return new GetDedicatedVmHostResponse(this.etag, this.opcRequestId, this.dedicatedVmHost);
        }

        public String toString() {
            return "GetDedicatedVmHostResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", dedicatedVmHost=" + this.dedicatedVmHost + ")";
        }
    }
}

