/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.DhcpOptions;
import java.beans.ConstructorProperties;

public class GetDhcpOptionsResponse {
    private String etag;
    private String opcRequestId;
    private DhcpOptions dhcpOptions;

    @ConstructorProperties(value={"etag", "opcRequestId", "dhcpOptions"})
    GetDhcpOptionsResponse(String etag, String opcRequestId, DhcpOptions dhcpOptions) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.dhcpOptions = dhcpOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DhcpOptions getDhcpOptions() {
        return this.dhcpOptions;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private DhcpOptions dhcpOptions;

        public Builder copy(GetDhcpOptionsResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.dhcpOptions(o.getDhcpOptions());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dhcpOptions(DhcpOptions dhcpOptions) {
            this.dhcpOptions = dhcpOptions;
            return this;
        }

        public GetDhcpOptionsResponse build() {
            return new GetDhcpOptionsResponse(this.etag, this.opcRequestId, this.dhcpOptions);
        }

        public String toString() {
            return "GetDhcpOptionsResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", dhcpOptions=" + this.dhcpOptions + ")";
        }
    }
}

