/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.DrgAttachment;
import java.beans.ConstructorProperties;

public class GetDrgAttachmentResponse {
    private String etag;
    private String opcRequestId;
    private DrgAttachment drgAttachment;

    @ConstructorProperties(value={"etag", "opcRequestId", "drgAttachment"})
    GetDrgAttachmentResponse(String etag, String opcRequestId, DrgAttachment drgAttachment) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.drgAttachment = drgAttachment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DrgAttachment getDrgAttachment() {
        return this.drgAttachment;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private DrgAttachment drgAttachment;

        public Builder copy(GetDrgAttachmentResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.drgAttachment(o.getDrgAttachment());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder drgAttachment(DrgAttachment drgAttachment) {
            this.drgAttachment = drgAttachment;
            return this;
        }

        public GetDrgAttachmentResponse build() {
            return new GetDrgAttachmentResponse(this.etag, this.opcRequestId, this.drgAttachment);
        }

        public String toString() {
            return "GetDrgAttachmentResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", drgAttachment=" + this.drgAttachment + ")";
        }
    }
}

