/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.IPSecConnectionDeviceConfig;
import java.beans.ConstructorProperties;

public class GetIPSecConnectionDeviceConfigResponse {
    private String etag;
    private String opcRequestId;
    private IPSecConnectionDeviceConfig iPSecConnectionDeviceConfig;

    @ConstructorProperties(value={"etag", "opcRequestId", "iPSecConnectionDeviceConfig"})
    GetIPSecConnectionDeviceConfigResponse(String etag, String opcRequestId, IPSecConnectionDeviceConfig iPSecConnectionDeviceConfig) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.iPSecConnectionDeviceConfig = iPSecConnectionDeviceConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public IPSecConnectionDeviceConfig getIPSecConnectionDeviceConfig() {
        return this.iPSecConnectionDeviceConfig;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private IPSecConnectionDeviceConfig iPSecConnectionDeviceConfig;

        public Builder copy(GetIPSecConnectionDeviceConfigResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.iPSecConnectionDeviceConfig(o.getIPSecConnectionDeviceConfig());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder iPSecConnectionDeviceConfig(IPSecConnectionDeviceConfig iPSecConnectionDeviceConfig) {
            this.iPSecConnectionDeviceConfig = iPSecConnectionDeviceConfig;
            return this;
        }

        public GetIPSecConnectionDeviceConfigResponse build() {
            return new GetIPSecConnectionDeviceConfigResponse(this.etag, this.opcRequestId, this.iPSecConnectionDeviceConfig);
        }

        public String toString() {
            return "GetIPSecConnectionDeviceConfigResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", iPSecConnectionDeviceConfig=" + this.iPSecConnectionDeviceConfig + ")";
        }
    }
}

