/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.IPSecConnection;
import java.beans.ConstructorProperties;

public class GetIPSecConnectionResponse {
    private String etag;
    private String opcRequestId;
    private IPSecConnection iPSecConnection;

    @ConstructorProperties(value={"etag", "opcRequestId", "iPSecConnection"})
    GetIPSecConnectionResponse(String etag, String opcRequestId, IPSecConnection iPSecConnection) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.iPSecConnection = iPSecConnection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public IPSecConnection getIPSecConnection() {
        return this.iPSecConnection;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private IPSecConnection iPSecConnection;

        public Builder copy(GetIPSecConnectionResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.iPSecConnection(o.getIPSecConnection());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder iPSecConnection(IPSecConnection iPSecConnection) {
            this.iPSecConnection = iPSecConnection;
            return this;
        }

        public GetIPSecConnectionResponse build() {
            return new GetIPSecConnectionResponse(this.etag, this.opcRequestId, this.iPSecConnection);
        }

        public String toString() {
            return "GetIPSecConnectionResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", iPSecConnection=" + this.iPSecConnection + ")";
        }
    }
}

