/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstanceConsoleConnection;
import java.beans.ConstructorProperties;

public class GetInstanceConsoleConnectionResponse {
    private String opcRequestId;
    private InstanceConsoleConnection instanceConsoleConnection;

    @ConstructorProperties(value={"opcRequestId", "instanceConsoleConnection"})
    GetInstanceConsoleConnectionResponse(String opcRequestId, InstanceConsoleConnection instanceConsoleConnection) {
        this.opcRequestId = opcRequestId;
        this.instanceConsoleConnection = instanceConsoleConnection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InstanceConsoleConnection getInstanceConsoleConnection() {
        return this.instanceConsoleConnection;
    }

    public static class Builder {
        private String opcRequestId;
        private InstanceConsoleConnection instanceConsoleConnection;

        public Builder copy(GetInstanceConsoleConnectionResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.instanceConsoleConnection(o.getInstanceConsoleConnection());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder instanceConsoleConnection(InstanceConsoleConnection instanceConsoleConnection) {
            this.instanceConsoleConnection = instanceConsoleConnection;
            return this;
        }

        public GetInstanceConsoleConnectionResponse build() {
            return new GetInstanceConsoleConnectionResponse(this.opcRequestId, this.instanceConsoleConnection);
        }

        public String toString() {
            return "GetInstanceConsoleConnectionResponse.Builder(opcRequestId=" + this.opcRequestId + ", instanceConsoleConnection=" + this.instanceConsoleConnection + ")";
        }
    }
}

