/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Instance;
import java.beans.ConstructorProperties;

public class GetInstanceResponse {
    private String etag;
    private String opcRequestId;
    private Instance instance;

    @ConstructorProperties(value={"etag", "opcRequestId", "instance"})
    GetInstanceResponse(String etag, String opcRequestId, Instance instance) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.instance = instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Instance instance;

        public Builder copy(GetInstanceResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.instance(o.getInstance());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public GetInstanceResponse build() {
            return new GetInstanceResponse(this.etag, this.opcRequestId, this.instance);
        }

        public String toString() {
            return "GetInstanceResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", instance=" + this.instance + ")";
        }
    }
}

