/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.NatGateway;
import java.beans.ConstructorProperties;

public class GetNatGatewayResponse {
    private String etag;
    private String opcRequestId;
    private NatGateway natGateway;

    @ConstructorProperties(value={"etag", "opcRequestId", "natGateway"})
    GetNatGatewayResponse(String etag, String opcRequestId, NatGateway natGateway) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.natGateway = natGateway;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public NatGateway getNatGateway() {
        return this.natGateway;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private NatGateway natGateway;

        public Builder copy(GetNatGatewayResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.natGateway(o.getNatGateway());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder natGateway(NatGateway natGateway) {
            this.natGateway = natGateway;
            return this;
        }

        public GetNatGatewayResponse build() {
            return new GetNatGatewayResponse(this.etag, this.opcRequestId, this.natGateway);
        }

        public String toString() {
            return "GetNatGatewayResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", natGateway=" + this.natGateway + ")";
        }
    }
}

